/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	ChalkBoard 
**
** DESCRIPTION:	Chalk board for construction plans
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef CHALKBOARD_H
#define CHALKBOARD_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "Puzzle.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const ldwPoint ChalkBoard_c_sPos(265, 1266);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CChalkBoard : public IPuzzle
{
	friend class CPuzzle;

private:

	//class enumerations
	enum ERef
	{
		eRef_BathPlans = ePuzzle_ChalkBoard + (1 << 16),
		eRef_StatuePlans = ePuzzle_ChalkBoard + (2 << 16)
	};

	//class structures
	struct SSaveState
	{
		bool	m_bContainsBathPlans;
		bool	m_bContainsStatuePlans;
	};

	//class data
	bool		m_bContainsBathPlans;
	bool		m_bContainsStatuePlans;
	float		m_fAlpha;

	//class methods
	//setup
	public:		CChalkBoard(void);
	public:		void Reset();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Advance(CVillager &Villager, const int iRef);

	// access
	public:		const bool ContainsPlans() const;
	public:		const bool ContainsBathPlans() const;
	public:		const bool ContainsStatuePlans() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CChalkBoard		ChalkBoard;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/